#default {
 finish {ambient 3/4 brilliance 0}
}
//The Guard and Cracker
#declare Guard_Uniform = pigment {cells color_map {[0 rgb <0,0,1>][1 rgb <0,1,1>]} scale 1/4}
#macro Guard()
 union {
  Beeple_Head(rgb <0,2/3,1>)
  Beeple_Guard_Hat(pigment {Guard_Uniform})
  Beeple_Eyes(rgb <0,7/8,1/3>)
  Beeple_Mouth(rgb 0)
  Beeple_Shirt_2M(pigment {Guard_Uniform},pigment {Guard_Uniform})
  Beeple_Pants(pigment {Guard_Uniform})
 }
#end
#declare Cracker_Pattern = pigment {crackle solid color_map {[0 rgb <1,0,0>][9/10 rgb <1,1,0>][1 rgb <0,1,0>]} scale 2/3}
#macro Cracker()
 union {
  Beeple_Head(rgb <1,2/3,1/3>)
  Fire_Hair()
  Beeple_Eyes(rgb <1,0,0>)
  Beeple_Mouth(rgb 0)
  Beeple_Shirt_2M(pigment {Cracker_Pattern},pigment {Cracker_Pattern})
  Beeple_Pants(pigment {Cracker_Pattern})
 }
#end

//Props
#declare Nothing = box {<0,0,0> <0,0,0>}

/*#declare Nightstick = cylinder {
 <0,0,0> <0,-2,0> 1/8
 pigment {rgb 0}
}*/

#macro Nightsaber(Length,Brightness)
union {
 cylinder {
  <0,0,0> <0,-2,0> 1/8
  pigment {rgb 0}
 }
 cylinder {
  <0,-2.251,0> <0,-2.25-Length,0> 1/8
  /*interior {
   media {
    emission 6
    intervals 5
    density {*/
  texture {
   pigment {
    cells color_map {[1/3 rgbt <0,2/3,1,1/4>][2/3 rgbt <0,0,2/3,1/4>]}
    scale 1/8
    translate <0,-clock,0>
   }
   finish {ambient Brightness diffuse 0}
  }
  interior_texture {
   pigment {rgbt 1}
  }
   /*}
   media {
    absorption 6
   }
  }
  pigment {rgbt 1}
  hollow*/
 }
}
#end

#macro Blue_Swoosh(Arc,Alpha)
intersection {
 cylinder {<0,-0.000001,0> <0,0.000001,0> 2}
 sphere {<0.25,0,0> 1.75 inverse}
 plane {<0,0,1> 0}
 plane {<0,0,1> 0 rotate <0,180+Arc,0>}
 pigment {
  spherical
  color_map {
   [0 rgb <0,0,1>]
   [0.04-0.04 rgbt <0,0,1,Alpha>]
   [0.25-0.04 rgbt <0,1,1,Alpha>]
  }
  scale <2.2,2,2>
  translate <1/16,0,0>
 }
 finish {ambient 1 diffuse 0}
}
#end

#macro Red_Fireball(Opacity)
sphere {
 0 2/3
 interior {
  media {
   emission 1.5*Opacity
   intervals 5
   density {
    cells color_map {[2/4 rgb <1,0,0>][1/2 rgb 0][2/4 rgb <1,1,0>]}
    scale 1/8
    translate <0,clock,0>
   }
   density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]}}
  }
  media {
   absorption 1*Opacity
   density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]}}
  }
 }
 pigment {rgbt 1}
 no_shadow
 hollow
}
#end

#macro Red_Fireburst(Opacity,Disperse)
merge {
 sphere {
  0 2/3
  interior {
   media {
    emission (1.5*Opacity)*(1-Disperse)
    intervals 5
    density {
     cells color_map {[2/4 rgb <1,0,0>][1/2 rgb 0][2/4 rgb <1,1,0>]}
     scale 1/8
     translate <0,clock,0>
    }
    density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} }//translate <0,Disperse,0>}
    //density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} translate <0,-Disperse,0>}
   }
   media {
    absorption (1*Opacity)*(1-Disperse)
    density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} }//translate <0,Disperse,0>}
    //density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} translate <0,-Disperse,0>}
   }
  }
  translate <0,Disperse*1,0>
 }
 sphere {
  0 2/3
  interior {
   media {
    emission (1.5*Opacity)*(1-Disperse)
    intervals 5
    density {
     cells color_map {[2/4 rgb <1,0,0>][1/2 rgb 0][2/4 rgb <1,1,0>]}
     scale 1/8
     translate <0,clock,0>
    }
    density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} }//translate <0,Disperse,0>}
    //density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} translate <0,-Disperse,0>}
   }
   media {
    absorption (1*Opacity)*(1-Disperse)
    density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} }//translate <0,Disperse,0>}
    //density {spherical color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]} translate <0,-Disperse,0>}
   }
  }
  translate <0,-Disperse*1,0>
 }
 pigment {rgbt 1}
 //translate <0,-1/2,0>
 no_shadow
 hollow
}
#end

#include "functions.inc"
#macro Red_Fireblast(Opacity,Radius)
merge {
 cylinder {<0,0,0> <0,-32,0> Radius}
 sphere {0 2/3}
 interior {
  media {
   emission 1.5*Opacity
   intervals 3
   density {
    cells color_map {[2/4 rgb <1,0,0>][1/2 rgb 0][2/4 rgb <1,1,0>]}
    scale 1/8
    translate <0,-clock*3,0>
   }
   density {function {max(1-min(1,sqrt(x*x+y*y+z*z)),Radius-min(Radius,sqrt(x*x+z*z)))} color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]}}
  }
  media {
   absorption 1*Opacity
   density {function {max(1-min(1,sqrt(x*x+y*y+z*z)),Radius-min(Radius,sqrt(x*x+z*z)))} color_map {[0 rgbt 0][3/4 rgb 1][1 rgb 1]}}
  }
 }
 pigment {rgbt 1}
 no_shadow
 hollow
}
#end

#macro Hyperspace_Hammer(Head)
union {
 cylinder {
  <0,0,0> <0,-3,0> 1/12
  pigment {rgb <1,1,0>}
 }
 cylinder {
  <-1/128-Head,-2.45,0> <1/128+Head,-2.45,0> Head
  pigment {rgb <1,0,0>}
 }
}
#end

//Strings
#declare Beeple_Head_Transform = transform {}
#declare Beeple_Hair_Transform = transform {}
#declare Evilness = 0;
#declare Evilness = 0;
#declare Beeple_Mouth_Position = 0;
#declare Beeple_Right_Arm_Transform = transform {}
#declare Beeple_Left_Arm_Transform = transform {}
#declare Beeple_Right_Leg_Transform = transform {}
#declare Beeple_Left_Leg_Transform = transform {}
#declare Beeple_Torso_Height = 2;
#declare Beeple_Arm_Length = 3/2;
#declare Beeple_Leg_Height = 7/2;
#declare Beeple_Leg_Spacing = 1/3;
#macro Beeple_Head_Full_Transform() transform {Beeple_Head_Transform} translate <0,Beeple_Torso_Height+Beeple_Leg_Height+3/2,0> #end //transform {Beeple_Torso_Transform} 

//Transformations
#macro Beeple_Right_Arm_Holds(Thing)
object {Thing translate <0,-Beeple_Arm_Length,0> transform {Beeple_Right_Arm_Transform} translate <-5/4,Beeple_Leg_Height+Beeple_Torso_Height,0>}
#end
#macro Beeple_Left_Arm_Holds(Thing)
object {Thing translate <0,-Beeple_Arm_Length,0> transform {Beeple_Left_Arm_Transform} translate <5/4,Beeple_Leg_Height+Beeple_Torso_Height,0>}//19/4
#end

#macro Beeple_Centered_Transform(Centered_Transform) translate <0,-Beeple_Leg_Height,0> transform {Centered_Transform} translate <0,Beeple_Leg_Height,0>#end


//Construction Pieces
#declare nudge = 0.000001;
#macro Beeple_Head(Skin_Color)
 sphere {
  <0,0,0> 1
  pigment { Skin_Color }
  Beeple_Head_Full_Transform()
 }
#end
#macro Beeple_Guard_Hat(Hat_Color)
 union {
 difference {
  union {
   sphere {<0,0,0> 1.1}
   difference {
    cylinder {<0,0,0> <0,1,0> 1.1}
    cylinder {<0,0,1> <0,-2,1> 1 scale <2,1,1> rotate <-30,0,0> translate <0,1,-1>}
   }
  }
  box {<-2,1/4,-2> <2,-4,2>}
 }
 difference {
  cylinder {<0,1/4,0> <0,1/4+nudge,0> 1 scale <1,1,2>}
  box {<-1,0,0> <1,1,2>}
 }
 pigment { Hat_Color }
 Beeple_Head_Full_Transform()
 }
#end
#macro Fire_Hair() 
object {
 intersection {
  sphere {0 4/3}
  plane {<0,-2,-1> 0 translate <0,1/3,-1>}
 }
 interior {
  media {
   emission 1.5
   intervals 1 //5
   density {
    cells color_map {[2/4 rgb <1,0,0>][1/2 rgb 0][2/4 rgb <1,1,0>]}
    scale 1/8
    translate <0,clock*64,0>
   }
   density {spherical color_map {[0 rgb 0][1/4 rgb 1][1 rgb 1]}scale 4/3}
  }
  media {
   absorption 1
   density {spherical color_map {[0 rgb 0][1/4 rgb 1][1 rgb 1]}scale 4/3}
  }
 }
 pigment {
  cells color_map {[1/4 rgb <1,0,0>][1/2 rgb <1,1/2,0>][3/4 rgb <1,1,0>]}
  scale 1/8
 }
 pigment {rgbt 1}
 //translate <0,1,0>
 scale <1,3/2,1>
 transform {Beeple_Hair_Transform}
 Beeple_Head_Full_Transform()
 no_shadow
 hollow
}
#end
#macro Beeple_Eyes(Eye_Color)
 union {
  sphere {
   <0,0,0> 1/20   
   scale <2,1-Evilness,1>
   rotate <0,0,-Evilness*90>
   translate <-1/5,0,-1>
  }
  sphere {
   <0,0,0> 1/20
   scale <2,1-Evilness,1>
   rotate <0,0,Evilness*90>
   translate <1/5,0,-1>
  }
  no_shadow
  pigment {Eye_Color}
  finish {ambient 1 diffuse 0}
  Beeple_Head_Full_Transform()
 }
#end
#macro Beeple_Mouth(Mouth_Color)
 sphere_sweep {
  b_spline
  6
  vrotate(<0,0,-61/60>,<-30-Beeple_Mouth_Position,30,0>) 0
  vrotate(<0,0,-61/60>,<-30,20,0>) 1/45
  vrotate(<0,0,-61/60>,<-30+Beeple_Mouth_Position,10,0>) 1/45
  vrotate(<0,0,-61/60>,<-30+Beeple_Mouth_Position,-10,0>) 1/45
  vrotate(<0,0,-61/60>,<-30,-20,0>) 1/45
  vrotate(<0,0,-61/60>,<-30-Beeple_Mouth_Position,-30,0>) 0
  pigment {Mouth_Color}
  no_shadow
  Beeple_Head_Full_Transform()
 }
#end
#macro Beeple_Shirt_2M(Shirt_Pigment,Arm_Pigment)
 union {
  prism {
   0-1 1
   4 <0,0> <-1/2,Beeple_Torso_Height> <1/2,Beeple_Torso_Height> <0,0>
   rotate <-90,0,0> scale <1,1,15/32>
   pigment {Shirt_Pigment}
  }
  cylinder {
   <0,0,0> <0,Beeple_Torso_Height,0> 1
   matrix <3/4,0,0, 1/4,1,0, 0,0,15/32, 0,0,0>
   pigment {Shirt_Pigment}
  }
  cylinder {
   <0,0,0> <0,Beeple_Torso_Height,0> 1
   matrix <3/4,0,0, -1/4,1,0, 0,0,15/32, 0,0,0>
   pigment {Shirt_Pigment}
  }
  sphere {<0,0,0> 1 scale <3/2,1/2,1/2> translate <0,Beeple_Torso_Height,0> pigment {Shirt_Pigment}}
  cylinder {<0,0,0> <0,-Beeple_Arm_Length,0> 1/4 pigment {Arm_Pigment} transform {Beeple_Left_Arm_Transform} translate <5/4,Beeple_Torso_Height,0>}
  cylinder {<0,0,0> <0,-Beeple_Arm_Length,0> 1/4 pigment {Arm_Pigment} transform {Beeple_Right_Arm_Transform} translate <-5/4,Beeple_Torso_Height,0>}
  sphere {<0,-Beeple_Arm_Length,0> 1/4 pigment {Arm_Pigment} transform {Beeple_Left_Arm_Transform} translate <5/4,Beeple_Torso_Height,0>}
  sphere {<0,-Beeple_Arm_Length,0> 1/4 pigment {Arm_Pigment} transform {Beeple_Right_Arm_Transform} translate <-5/4,Beeple_Torso_Height,0>}
  translate <0,Beeple_Leg_Height,0>
 }
#end
#macro Beeple_Pants(Pants_Pigment)
 union {
  sphere {<0,0,0> 1 scale <3/4,1/2,1/2> /*scale <1,1,2/3>*/}
  cylinder {<0,0,0> <0,-Beeple_Leg_Height,0> 1/4 transform {Beeple_Right_Leg_Transform} translate <-1/3,-3/16,0>}
  cylinder {<0,0,0> <0,-Beeple_Leg_Height,0> 1/4 transform {Beeple_Left_Leg_Transform} translate <1/3,-3/16,0>}
  pigment {Pants_Pigment}
  translate <0,Beeple_Leg_Height,0>
 }
#end